﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace MojaPierwszaGra;

public class Game1 : Game
{
    private GraphicsDeviceManager _graphics;
    private SpriteBatch _spriteBatch;

    private BasicEffect efekt;
    private VertexPositionColor[] werteksyTrójkąta = new VertexPositionColor[3]
    {
        new VertexPositionColor(new Vector3(0.5f, -0.5f, 0), Color.Cyan),
        new VertexPositionColor(new Vector3(-0.5f, -0.5f, 0), Color.Yellow),
        new VertexPositionColor(new Vector3(0, 0.5f, 0), Color.Magenta)
    };
    private VertexBuffer buforWerteksowTrojkata;

    public Game1()
    {
        _graphics = new GraphicsDeviceManager(this);
        Content.RootDirectory = "Content";
        IsMouseVisible = true;
    }

    protected override void Initialize()
    {
        // TODO: Add your initialization logic here
        GraphicsDevice.RasterizerState = RasterizerState.CullCounterClockwise;

        //RasterizerState rs = new RasterizerState();
        //rs.CullMode = CullMode.None;
        //rs.FillMode = FillMode.WireFrame;
        //_graphics.GraphicsDevice.RasterizerState = rs;

        efekt = new BasicEffect(_graphics.GraphicsDevice);        
        efekt.VertexColorEnabled = true;

        //efekt.Projection = Matrix.CreateOrthographic(
        //    2.0f * _graphics.GraphicsDevice.Viewport.AspectRatio, 
        //    2.0f, 0.0f, 100.0f);
        /*
        efekt.Projection = Matrix.CreatePerspective(
            2.0f * _graphics.GraphicsDevice.Viewport.AspectRatio,
            2.0f, 1.0f, 100.0f);
        */
        efekt.Projection = Matrix.CreatePerspectiveFieldOfView(
            MathHelper.PiOver2, 
            _graphics.GraphicsDevice.Viewport.AspectRatio,
            1.0f, 100.0f);
        //efekt.View = Matrix.CreateTranslation(0, 0, -1);
        efekt.View = Matrix.CreateLookAt(
            new Vector3(0, 0, 1), //położenie kamery
            new Vector3(0, 0, 0), //punkt, na który kamera jest skierowana
            new Vector3(0, 1, 0)); //kierunek góry kamery (polaryzacja)

        buforWerteksowTrojkata = new VertexBuffer(
            _graphics.GraphicsDevice,
            VertexPositionColor.VertexDeclaration,
            werteksyTrójkąta.Length,
            BufferUsage.WriteOnly);
        buforWerteksowTrojkata.SetData<VertexPositionColor>(werteksyTrójkąta);

        base.Initialize();
    }

    protected override void LoadContent()
    {
        _spriteBatch = new SpriteBatch(GraphicsDevice);

        // TODO: use this.Content to load your game content here
    }

    protected override void Update(GameTime gameTime)
    {
        if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed || Keyboard.GetState().IsKeyDown(Keys.Escape))
            Exit();

        // TODO: Add your update logic here
        /*
        Matrix macierzPrzeksztalcenia = Matrix.Identity;
        macierzPrzeksztalcenia *= Matrix.CreateScale(0.5f);
        macierzPrzeksztalcenia *= Matrix.CreateRotationZ(-MathHelper.PiOver2);
        macierzPrzeksztalcenia *= Matrix.CreateTranslation(0.5f, 0, 0);
        efekt.World = macierzPrzeksztalcenia;
        */
        efekt.World *= Matrix.CreateRotationZ(gameTime.ElapsedGameTime.Milliseconds/1000.0f);

        base.Update(gameTime);
    }

    protected override void Draw(GameTime gameTime)
    {
        //GraphicsDevice.Clear(Color.CornflowerBlue);

        GraphicsDevice gd = _graphics.GraphicsDevice;
        gd.Clear(Color.Black);

        /*
        foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
        {
            pass.Apply();
            //Instrukcje rysujące trójkąt
            gd.DrawUserPrimitives<VertexPositionColor>(
                PrimitiveType.TriangleList,
                werteksyTrójkąta,
                0,
                1);
        }
        */
        gd.SetVertexBuffer(buforWerteksowTrojkata);
        foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
        {
            pass.Apply();
            gd.DrawUserPrimitives<VertexPositionColor>(
                PrimitiveType.TriangleList,werteksyTrójkąta, 0, 1);
            gd.DrawPrimitives(PrimitiveType.TriangleList, 0, 1);
        }

        base.Draw(gameTime);
    }

    


}
